﻿/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - DTC Printers                            **/
/**                                                                       **/
/**  MODULE NAME  : Main.cs                                               **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Windows.Forms;
using System.Drawing.Printing;
using System.Collections;
using System.Collections.Generic;
using SDKShim;

namespace CSharpDemo
{
    [System.Runtime.InteropServices.GuidAttribute("C60551F2-7329-4249-866F-3D0DBA37CD61")]
    public partial class SDK_CSDemo : Form
    {
        #region === Initialisation ===

        private bool InfoTabInit      = false;
        private bool EncodingTabInit  = false;
        private bool Driver1TabInit   = false;
        private bool Driver2TabInit   = false;
        private bool PrintDemoTabInit = false;
        private bool UtilsTabInit     = false;

        public SDK_CSDemo()
        {
            InitializeComponent();

#if (x86)
            this.Text = "DTC SDK C# Demo (32 bit)";
#else
            this.Text = "DTC SDK C# Demo (64 bit)";
#endif
            //Hide tabs other than Printer Settings
            TabControl.Controls.Remove(Information);
            TabControl.Controls.Remove(MagEncoding);
            TabControl.Controls.Remove(DriverSettings1);
            TabControl.Controls.Remove(DriverSettings2);
            TabControl.Controls.Remove(PrintDemo);
            TabControl.Controls.Remove(Utils);

            //Initialise the individual tabs
            InitPrinterTab();
            InitInfoTab();
            InitEncodingTab();
            InitDriver1Tab();
            InitDriver2Tab();
            InitPrintDemoTab();
            InitUtilsTab();
        }

        #endregion === Initialisation ===

        //----------------------------------------------------------------------

        #region === Local Methods ===

        private void TabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            switch (TabControl.SelectedIndex)
            {
			case 0:
                // Printer tab does not require initialisation
				break;
				
            case 1:
                if (!InfoTabInit)
                {
                    InfoTabInit = true;

                    if (printerType == SDK.PrinterType.Generation2)
                    {
                        PasswordButton.Enabled  = true;
                        Password1.Enabled = true;
                        Password2.Enabled = true;
                        PwdCommandCombo.Enabled = true;
                        Pwd1Label.Enabled = true;
                        Pwd2Label.Enabled = true;

                        foreach (ParamSet p in paramTable)
                        {
                            ParamCombo.Items.Add(p.Text);
                        }
                        ParamCombo.SelectedIndex = 0;
                    }
                    else
                    {
                        Generation2GroupBox.Visible = false;
                    }
                }
                break;

            case 2:
                if (!EncodingTabInit)
                {
                    EncodingTabInit = true;

                    if (printerType == SDK.PrinterType.Generation2)
                    {
                        ParityLabel.Visible      = false;
                        LRCLabel.Visible         = false;
                        T1_ParityCombo.Visible   = false;
                        T2_ParityCombo.Visible   = false;
                        T3_ParityCombo.Visible   = false;
                        T1_LRCCombo.Visible      = false;
                        T2_LRCCombo.Visible      = false;
                        T3_LRCCombo.Visible      = false;
                        MagStartButton.Enabled   = true;
                        EncodingGetRadio.Enabled = true;
                        EncodingSetRadio.Enabled = true;

                        //...Magnetic Encoding Start Position
                        int MagStart = 0;
                        GetMagStart(ref MagStart);
                    }
                }
                break;

            case 3:
                //Always check the resolution
                if (PrinterIs600DPICapable())
                {
                    byte resolution = 0;
                    GetResolution(ref resolution);
                    ResolutionButton.Enabled = true;
                }

                if (!Driver1TabInit)
                {
                    Driver1TabInit = true;
                    SDK.Area Area = new SDK.Area();

                    if (printerType == SDK.PrinterType.Generation2)
                    {
                        PrintSpeedButton.Visible    = false;
                        PrintSpeedCombo.Visible     = false;
                        EraseEndPowerLabel.Visible  = false;
                        ErasePowerEndUpDown.Visible = false;
                        WritePowerLabel.Visible     = false;
                        WritePowerUpDown.Visible    = false;

                        YMCPowerUpDown.Minimum      = -100;
                        ResinPowerUpDown.Minimum    = -100;
                        OvercoatPowerUpDown.Minimum = -100;

                        ResinAreaLeftUpDown.Maximum      = SDK.ID_CardWidth(hSession) - 1;
                        ResinAreaWidthUpDown.Maximum     = SDK.ID_CardWidth(hSession);
                        PrintableAreaLeftUpDown.Maximum  = SDK.ID_CardWidth(hSession) - 1;
                        PrintableAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession);
                        AreaHoleLeftUpDown.Maximum       = SDK.ID_CardWidth(hSession) - 1;
                        AreaHoleWidthUpDown.Maximum      = SDK.ID_CardWidth(hSession);
                        EraseAreaLeftUpDown.Maximum      = SDK.ID_CardWidth(hSession) - 1;
                        EraseAreaWidthUpDown.Maximum     = SDK.ID_CardWidth(hSession);

                        //...Printable Area
                        GetPrintableArea(ref Area);
                    }
                    else
                    {
                        PrintSpeedButton.Visible    = true;
                        PrintSpeedCombo.Visible     = true;
                        PrintableAreaButton.Enabled = true;
                        EraseEndPowerLabel.Visible  = true;
                        ErasePowerEndUpDown.Visible = true;
                        WritePowerLabel.Visible     = true;
                        WritePowerUpDown.Visible    = true;

                        YMCPowerUpDown.Minimum      = 0;
                        ResinPowerUpDown.Minimum    = 0;
                        OvercoatPowerUpDown.Minimum = 0;

                        //...Print Speed
                        SDK.PrintSpeed PrintSpeed = new SDK.PrintSpeed();
                        GetPrintSpeed(ref PrintSpeed);
                    }

                    //Initialise the Controls on the Driver 1 Page...
                    //...GUIControl
                    SDK.GUIControl control = new SDK.GUIControl();
                    GetGUIControl(ref control);

                    //...Sharpness
                    sbyte temp = 0;
                    GetSharpness(ref temp);

                    //...Colour Correction
                    SDK.Correction ColCorrect = new SDK.Correction();
                    GetColourCorrection(ref ColCorrect);

                    //...Power Level
                    SDK.PowerLevel PowerLevel = new SDK.PowerLevel();
                    GetPowerLevels(ref PowerLevel);

                    //...Resin Area
                    GetResinArea(SDK.Side.Front, 1, ref Area);

                    //...AreaHole(s)
                    GetAreaHole(SDK.Side.Front, SDK.AreaHole.Area, 1, ref Area);

                    //...Rewritable
                    SDK.Rewritable Rewritable = new SDK.Rewritable();
                    GetRewritable(ref Rewritable);
                }
                break;

            case 4:
                if (!Driver2TabInit)
                {
                    Driver2TabInit = true;

                    foreach (PaperSize p in pd.PrinterSettings.PaperSizes)
                    {
                        cardsizekp.Add(p.RawKind, p.PaperName);
                    }
                    CardSizeCombo.DataSource = new BindingSource(cardsizekp, null);
                    CardSizeCombo.DisplayMember = "Value";
                    CardSizeCombo.ValueMember = "Key";

                    //Initialise the Controls on the Driver 2 Page...
                    //...Print Settings
                    SDK.PrintSetting PrintSettings = new SDK.PrintSetting();
                    GetPrintSettings(ref PrintSettings);

                    //...Card Settings
                    SDK.CardSetting CardSettings = new SDK.CardSetting();
                    GetCardSettings(SDK.Side.Front, ref CardSettings);

                    //...HoloKote
                    SDK.HoloKote HoloKote = new SDK.HoloKote();
                    GetHoloKote(SDK.Side.Front, ref HoloKote);

                    //...HoloPatch
                    SDK.HoloPatch HoloPatch = new SDK.HoloPatch();
                    GetHoloPatch(ref HoloPatch);

                    //...ColourArea
                    ColourAreaLeftUpDown.Maximum  = SDK.ID_CardWidth(hSession) - 1;
                    ColourAreaWidthUpDown.Maximum = SDK.ID_CardWidth(hSession);
                    SDK.Area Area = new SDK.Area();
                    SDK.Correction Correction = new SDK.Correction();
                    GetColourArea(SDK.Side.Front, 1, Area, ref Correction);

                    //...ColourAdjust
                    SDK.ColorAdjustment ColourAdj = new SDK.ColorAdjustment();
                    GetColourAdjust(ref ColourAdj);
                }
                break;

            case 5:
                if (!PrintDemoTabInit)
                {
                    PrintDemoTabInit = true;

                    ShapeFrontFillCombo.Text   = "Transparent";
                    TextBackColourCombo.Text   = "Black";
                    ShapeBackOutlineCombo.Text = "Black";
                    ShapeBackFillCombo.Text    = "Transparent";
                    LineBackColourCombo.Text   = "Black";
                }

	            Functions600DPI.Visible = PrinterIs600DPICapable();
                Functions600DPI.Checked = Radio600DPI.Checked;
                break;

            case 6:
                if (!UtilsTabInit)
                {
                    UtilsTabInit = true;

                    if (printerType != SDK.PrinterType.Generation2)
                    {
                        SendAPDUBox.Enabled = false;
                        SendAPDUButton.Enabled = false;
                    }
                }
                break;
            }
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === Child Methods ===

        private void HandleError(string action, SDK.Return result)
        {
            string error;

            switch (result)
            {
            case SDK.Return.Timeout:            error = "ID_TIMEOUT";             break;
            case SDK.Return.Error:              error = "ID_ERROR";               break;
            case SDK.Return.PrinterError:       error = "ID_PRINTER_ERROR";       break;
            case SDK.Return.DriverNotCompliant: error = "ID_DRIVER_NOTCOMPLIANT"; break;
            case SDK.Return.OpenPrinterError:   error = "ID_OPENPRINTER_ERROR";   break;
            case SDK.Return.RemoteCommError:    error = "ID_REMOTECOMM_ERROR";    break;
            case SDK.Return.LocalCommError:     error = "ID_LOCALCOMM_ERROR";     break;
            case SDK.Return.SpoolerNotEmpty:    error = "ID_SPOOLER_NOT_EMPTY";   break;
            case SDK.Return.RemoteCommInUse:    error = "ID_REMOTECOMM_IN_USE";   break;
            case SDK.Return.LocalCommInUse:     error = "ID_LOCALCOMM_IN_USE";    break;
            case SDK.Return.ParamError:         error = "ID_PARAM_ERROR";         break;
            case SDK.Return.InvalidSession:     error = "ID_INVALID_SESSION";     break;
            case SDK.Return.MoreData:           error = "ID_MORE_DATA";           break;
            case SDK.Return.InvalidPrinter:     error = "ID_INVALID_PRINTER";     break;
            case SDK.Return.InvalidAction:      error = "ID_INVALID_ACTION";      break;
            case SDK.Return.ReadError:          error = "ID_READ_ERROR";          break;
            case SDK.Return.WriteError:         error = "ID_WRITE_ERROR";         break;
            case SDK.Return.NoMagData:          error = "ID_NO_MAG_DATA";         break;
            case SDK.Return.NoAPDUData:         error = "ID_NO_APDU_DATA";        break;
            default: error = "Unknown API Error - " + result; break;
            }
            MessageBox.Show(action + ": " + error);
        }

        //----------------------------------------------------------------------

        private void WaitForPrinterToFinish()
        {
            if (pd.PrintToFile)
                return;

            if (printerType == SDK.PrinterType.Generation2)
                return;

            Cursor.Current = Cursors.WaitCursor;

            do
            {
                //Repeat the wait until response is not timeout
            } while (SDK.ID_WaitForPrinter(hSession) == SDK.Return.Timeout);

            Cursor.Current = Cursors.Default;
        }

        //----------------------------------------------------------------------

        private string Separator(SDK.Action action)
        {
            return (action == SDK.Action.Read) ? ": " : " -> ";
        }

        //----------------------------------------------------------------------

        private void ExitButton_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        #endregion === Child Methods ===
        

    }
}